precision highp float;

uniform vec4 uClipPlane;
uniform vec3 uLightAmb;
uniform vec3 uLightDif;
uniform vec3 uLightSky;
uniform vec4 uBaseColor;
uniform vec4 uFlagColor;
uniform sampler2D uTexture;

varying vec3 C; // Color
varying vec3 L; // Light
varying vec3 N; // Normal
varying vec3 P; // Position
varying vec2 UV; // UV

void main()
{

  /* Discard pixels behind Clipping Plane */
  float clipPos = dot(P, uClipPlane.xyz) + uClipPlane.w;
  if (clipPos < 0.0) {
    discard;
  }

  vec3 ecNormal = normalize(N);
  float ecDotDirection = max(0.0, dot(ecNormal, L));
  vec3 diffuse = ecDotDirection * uLightDif;

  float ecSkyDirection = max(0.0, dot(ecNormal, vec3(0, 0, 1)));
  vec3 sky = ecSkyDirection * uLightSky;
  vec3 light = diffuse + uLightAmb + sky;

  vec4 tex = texture2D(uTexture, UV);

  // We know the pole from the flag by it's color. Flag has only Red component in LWO model. Pole is RGB mostly
  gl_FragColor.rgb = mix(uFlagColor.rgb, C.rgb, step(0.5, C.g)) * tex.rgb * light.rgb * uBaseColor.rgb;
  gl_FragColor.a = tex.a * uBaseColor.a * uFlagColor.a;
}